/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.ws.base.VWUDDIRegistryItem;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;

public class VWUDDIRegistryComboBoxRenderer
extends DefaultListCellRenderer {
    private final ImageIcon ICON_UNKNOWN = VWImageLoader.createImageIcon("uddiRegistryUnknown.gif");
    private final ImageIcon ICON_CONNECTED = VWImageLoader.createImageIcon("uddiRegistry.gif");
    private final ImageIcon ICON_UNREACHABLE = VWImageLoader.createImageIcon("uddiRegistryBad.gif");

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        try {
            if (value != null) {
                if (value instanceof VWUDDIRegistryItem) {
                    VWUDDIRegistryItem aEle = (VWUDDIRegistryItem)value;
                    String businessName = aEle.getBusinessName();
                    if (businessName == null) {
                        businessName = "";
                    }
                    this.setText(aEle.getName() + " : " + businessName);
                    int regState = aEle.getState();
                    if (regState == 1) {
                        ((JLabel)component).setIcon(this.ICON_CONNECTED);
                        ((JLabel)component).setToolTipText(VWResource.s_registryStateConnected);
                    } else if (regState == 2) {
                        ((JLabel)component).setIcon(this.ICON_UNREACHABLE);
                        ((JLabel)component).setToolTipText(VWResource.s_registryStateUnreachable);
                    } else {
                        ((JLabel)component).setIcon(this.ICON_UNKNOWN);
                        ((JLabel)component).setToolTipText(VWResource.s_registryStateUnknown);
                    }
                } else if (value instanceof String) {
                    ((JLabel)component).setText((String)value);
                } else {
                    ((JLabel)component).setText("");
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return component;
    }
}

